function out = fct_EM_unconditional(EMinput)

    mm_mat = fieldnames( EMinput );
    for i = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(i)) '= EMinput.(cell2mat(mm_mat(i)));']);
    end

% initial point, update it in the loop
    g_vec      = g_vec_ini;
    mu_vec     = mu_vec_ini;
    sigma_vec  = sigma_vec_ini;

% this function takes initial guess and calculates EM estimate without any
% conditioning on [tlow,thigh] interval
K = length(g_vec);
MM = max(size(data_EM));
Npeople = sum(data_EM(:,3));
%
use_Elog = 0;
% Minimum values for parameters
%g_min       = 1e-20 ;     
%sigma_min   = 0.00001;  % this is needed so that f > 0  
%z_min       = 1e-300;
%
step = 1/2;
%

% ORIGINAL LINES
t1_vec = data_EM(:,1)+step; % vector of times t1, 
t2_vec = data_EM(:,2)+step; % vector of times t2
%it adds step  because probability is during the week that starts at
% data_EM(:,1) or data_EM(:,1)
%
% t1veclog and t2veclog add 1/2 step, so that the minimum value is 3/2 step
% this avoids taking the log of zero in one version wehre we want to correc the Jensen's inequality
% effec of estimating E[1/t] using discretize data. 
% we use this when use_Elog =  1. 
t1_veclog = t1_vec;
t1_veclog = max(t1_vec,3/2*step); 
t2_veclog = t2_vec;
t2_veclog = max(t2_vec,3/2*step);
%
%
% calculate 
    z=zeros(K,MM);
    % computes z(k,j) = share of observations with pairs (t1,t2) indexed by
    % j that comes from type j
    % k type in 1,..,K and j is a combination of spells (t1,t2) out of MM.
    
    tlow = min(data_EM(:,1));
    thigh = max(data_EM(:,1));
    %%%%%%

    for k=1:K 
        mu     =  mu_vec(k,1);
        sigma  =  sigma_vec(k,1);
        %
        Flow  = fct_CDF_F_capped(tlow,mu,sigma)  ;
        Fhigh = fct_CDF_F_capped(thigh,mu,sigma) ;
        %
        if Fhigh > Flow
            f1 = fct_pdf_f(t1_vec,mu,sigma);
            f2 = fct_pdf_f(t2_vec,mu,sigma);
%             k
%             MM
%             size(f1)
%             size(f2)
%             size(g_vec(k,1))
%             size(z(k,1:MM))
            z(k,1:MM) = f1 .* f2 .* g_vec(k,1) ;
        else
            z(k,1:MM) = ones(1,MM)*z_min ;
        end
    end
    % normalize
    zsum = sum(z);
    z = z./repmat(zsum,K,1);

    %%%% M step: find  mu,sigma using ML for each k:
    %
    %
    %
    %%%%  updates mu(k), sigma(k) estimates, using MLE for each type k:
    %
    % these lines use the mean of t and mean of 1/t.
    % each expectation is taken with respect to the weighted distribution,
    % usign z
    %
    % E_t(k) = E[ t | type k ] and E_1over_t(k) = E[ 1/t | type k]
    %
    % since they are conditioning on coming from type k, we weight the
    % distribution of (t1,t2) in the data by z(k,t1,t2)
    %
    for k=1:K
        E_t(k,1) =  0.5*(t1_vec+t2_vec)' * ...
            (z(k,:)' .* data_EM(:,3))/sum(z(k,:)' .* data_EM(:,3));

        
        %
        if use_Elog == 1

            E_1_over_t(k,1) =  0.5 * ( log(t1_veclog-step+1)-log(t1_veclog-step) + log(t2_veclog-step+1)-log(t2_veclog-step) )' * ...
            (z(k,:)' .* data_EM(:,3)) / sum( z(k,:)' .* data_EM(:,3));  
                   
        else   
            E_1_over_t(k,1) =  0.5 * (1./t1_vec + 1./t2_vec )' * ...
            (z(k,:)' .* data_EM(:,3)) / sum( z(k,:)' .* data_EM(:,3));
        end
    end

    % update mu and sigma
    mu_old = mu_vec;
    sigma_old = sigma_vec;
    
    mu_vec    = 1./E_t;
    sigma_vec = sqrt(max(mu_vec.^2.*E_t + E_1_over_t - 2*mu_vec ,1e-100) );
    mu_new    = max(mu_min, mu_vec) ;
    sigma_new = max(sigma_min,sigma_vec);

    mu_new = (mu_new + mu_old)/2;
    sigma_new = (sigma_new + sigma_old)/2;

    
    % update g
    for k = 1:K
        mu     =  mu_new(k);
        sigma  =  sigma_new(k);
        f1 = fct_pdf_f(t1_vec,mu,sigma);
        f2 = fct_pdf_f(t2_vec,mu,sigma);
        z(k,1:MM) = f1 .* f2 .* g_vec(k,1) ;
    end
    zsum = sum(z);
    z = z./repmat(zsum,K,1);   
    g_new  = z*data_EM(:,3)/Npeople;
    
    out.g_vec = g_new;
    out.mu_vec = mu_new ;
    out.sigma_vec = sigma_new;
    
  
end